/*
 * Decompiled with CFR 0.152.
 */
package love.ikaros.minecraft.item;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import love.ikaros.minecraft.sound.ModSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_7923;

public class SphereChaosStaffItem
extends class_1792 {
    private static final Random RANDOM = new Random();
    private static final int INTERVAL = 4;
    private static final int SOUND_LOOP_TICKS = 160;
    private static List<class_2248> CACHED_BLOCKS = null;

    public SphereChaosStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        user.method_6019(hand);
        return class_1271.method_22428((Object)stack);
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (world.field_9236 || !(user instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)user;
        class_2338 center = user.method_24515();
        int usedTicks = this.method_7881(stack) - remainingUseTicks;
        if (usedTicks % 160 == 0) {
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), ModSoundEvents.NYMPH_WAND_USE, class_3419.field_15248, 1.0f, 1.0f);
        }
        int cycle = usedTicks / 4;
        int currentRadius = 2 + cycle * 2;
        int innerRadius = Math.max(0, currentRadius - 2);
        if (usedTicks > 0 && usedTicks % 4 == 0) {
            this.clearSphereShell(world, center, innerRadius, Math.max(0, innerRadius - 2));
            this.spawnSoulFireParticles((class_3218)world, center, currentRadius);
            if (usedTicks % 20 == 0) {
                player.method_7353(class_2561.method_30163((String)("\u00a7b\u6df7\u6c8c\u6269\u5f20\u534a\u5f84: \u00a7f" + currentRadius)), true);
            }
        } else {
            this.applySphereShellEffect(world, center, currentRadius, innerRadius);
        }
    }

    private void spawnSoulFireParticles(class_3218 world, class_2338 center, int radius) {
        int particleCount = radius * 100;
        for (int i = 0; i < particleCount; ++i) {
            double u = RANDOM.nextDouble();
            double v = RANDOM.nextDouble();
            double theta = Math.PI * 2 * u;
            double phi = Math.acos(2.0 * v - 1.0);
            double x = (double)center.method_10263() + 0.5 + (double)radius * Math.sin(phi) * Math.cos(theta);
            double y = (double)center.method_10264() + 0.5 + (double)radius * Math.sin(phi) * Math.sin(theta);
            double z = (double)center.method_10260() + 0.5 + (double)radius * Math.cos(phi);
            world.method_14199((class_2394)class_2398.field_22246, x, y, z, 1, 0.1, 0.1, 0.1, 0.05);
        }
    }

    private void applySphereShellEffect(class_1937 world, class_2338 center, int outerRadius, int innerRadius) {
        this.iterateShell(center, outerRadius, innerRadius, pos -> {
            class_2680 currentState;
            if (world.method_24794(pos) && !(currentState = world.method_8320(pos)).method_26215() && RANDOM.nextInt(3) == 0) {
                world.method_8652(pos, this.getRandomBlockState(), 2);
            }
        });
    }

    private void clearSphereShell(class_1937 world, class_2338 center, int outerRadius, int innerRadius) {
        this.iterateShell(center, outerRadius, innerRadius, pos -> {
            if (world.method_24794(pos)) {
                world.method_8652(pos, class_2246.field_10124.method_9564(), 34);
            }
        });
        class_238 box = new class_238(center).method_1014((double)outerRadius + 1.0);
        List items = world.method_8390(class_1542.class, box, item -> true);
        items.forEach(class_1297::method_31472);
    }

    private void iterateShell(class_2338 center, int outerRadius, int innerRadius, Consumer<class_2338> action) {
        int sqOuter = outerRadius * outerRadius;
        int sqInner = innerRadius * innerRadius;
        for (int x = -outerRadius; x <= outerRadius; ++x) {
            for (int y = -outerRadius; y <= outerRadius; ++y) {
                for (int z = -outerRadius; z <= outerRadius; ++z) {
                    int distanceSq = x * x + y * y + z * z;
                    if (distanceSq > sqOuter || distanceSq <= sqInner) continue;
                    action.accept(center.method_10069(x, y, z));
                }
            }
        }
    }

    private class_2680 getRandomBlockState() {
        if (CACHED_BLOCKS == null && (CACHED_BLOCKS = class_7923.field_41175.method_10220().filter(b -> {
            class_2680 state = b.method_9564();
            return !state.method_26215() && state.method_26225() && !(b instanceof class_2343);
        }).collect(Collectors.toList())).isEmpty()) {
            CACHED_BLOCKS.add(class_2246.field_10340);
        }
        return CACHED_BLOCKS.get(RANDOM.nextInt(CACHED_BLOCKS.size())).method_9564();
    }
}

