/*
 * Decompiled with CFR 0.152.
 */
package love.ikaros.minecraft.item;

import java.util.List;
import love.ikaros.minecraft.sound.ModSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class SoulBeamItem
extends class_1792 {
    public SoulBeamItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.field_9236) {
            this.executeSoulBeam(world, user);
            world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), ModSoundEvents.CHRYSAOR_SWORD, class_3419.field_15248, 10.0f, 1.0f);
            user.method_7357().method_7906((class_1792)this, 5);
        }
        user.method_6104(hand);
        return class_1271.method_22427((Object)stack);
    }

    private void executeSoulBeam(class_1937 world, class_1657 user) {
        class_243 startPos = user.method_33571();
        class_243 lookDir = user.method_5828(1.0f).method_1029();
        double radius = 70.0;
        double angleLimitDeg = 22.5;
        double angleLimitRad = Math.toRadians(angleLimitDeg);
        double halfThickness = 3.0;
        class_243 verticalAxis = Math.abs(lookDir.field_1351) > 0.9 ? new class_243(1.0, 0.0, 0.0) : new class_243(0.0, 1.0, 0.0);
        class_243 rightVec = lookDir.method_1036(verticalAxis).method_1029();
        class_243 upVec = rightVec.method_1036(lookDir).method_1029();
        double rollRad = Math.toRadians(45.0);
        class_243 planeNormal = upVec.method_1021(Math.cos(rollRad)).method_1019(rightVec.method_1021(Math.sin(rollRad))).method_1029();
        class_243 planeHorizontal = rightVec.method_1021(Math.cos(rollRad)).method_1020(upVec.method_1021(Math.sin(rollRad))).method_1029();
        class_238 scanBox = new class_238(startPos, startPos).method_1014(radius);
        List targets = world.method_8335((class_1297)user, scanBox);
        for (class_1297 entity : targets) {
            Object relativePos;
            class_1309 target;
            if (!(entity instanceof class_1309) || !(target = (class_1309)entity).method_5805() || !this.checkImpact((class_243)(relativePos = target.method_5829().method_1005().method_1020(startPos)), lookDir, planeNormal, radius, angleLimitRad, halfThickness)) continue;
            target.method_5643(world.method_48963().method_48802(user), 1000.0f);
            target.method_6005(5.0, -lookDir.field_1352, -lookDir.field_1350);
        }
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_2338 min = class_2338.method_49637((double)(startPos.field_1352 - radius), (double)(startPos.field_1351 - radius), (double)(startPos.field_1350 - radius));
            class_2338 max = class_2338.method_49637((double)(startPos.field_1352 + radius), (double)(startPos.field_1351 + radius), (double)(startPos.field_1350 + radius));
            for (class_2338 bPos : class_2338.method_10097((class_2338)min, (class_2338)max)) {
                class_2680 state;
                class_243 relativePos = class_243.method_24953((class_2382)bPos).method_1020(startPos);
                if (!this.checkImpact(relativePos, lookDir, planeNormal, radius, angleLimitRad, halfThickness) || (state = world.method_8320(bPos)).method_26215() || !(state.method_26214((class_1922)world, bPos) >= 0.0f)) continue;
                world.method_8652(bPos, class_2246.field_10124.method_9564(), 3);
            }
            double visualRadius = 70.0;
            for (double r = 0.8; r <= visualRadius; r += 2.0) {
                for (double a = -angleLimitDeg; a <= angleLimitDeg; a += 2.0) {
                    double radA = Math.toRadians(a);
                    class_243 sectorDir = lookDir.method_1021(Math.cos(radA)).method_1019(planeHorizontal.method_1021(Math.sin(radA)));
                    class_243 pPos = startPos.method_1019(sectorDir.method_1021(r));
                    serverWorld.method_14199((class_2394)class_2398.field_22246, pPos.field_1352, pPos.field_1351, pPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private boolean checkImpact(class_243 relativePos, class_243 lookDir, class_243 planeNormal, double radius, double angleLimitRad, double halfThickness) {
        double distSq = relativePos.method_1027();
        if (distSq > radius * radius || distSq < 0.25) {
            return false;
        }
        double dist = Math.sqrt(distSq);
        class_243 normRelative = relativePos.method_1021(1.0 / dist);
        double dot = normRelative.method_1026(lookDir);
        if (Math.acos(class_3532.method_15350((double)dot, (double)-1.0, (double)1.0)) > angleLimitRad) {
            return false;
        }
        double distanceToPlane = Math.abs(relativePos.method_1026(planeNormal));
        return distanceToPlane <= halfThickness;
    }
}

