/*
 * Decompiled with CFR 0.152.
 */
package love.ikaros.minecraft.item;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import love.ikaros.minecraft.sound.ModSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7923;

public class RandomStaffItem
extends class_1792 {
    private static final String DATA_FILE = "world_backup.nbt";
    private static final AtomicBoolean IS_RECORDING = new AtomicBoolean(false);
    private static class_2338 recordCenter = null;
    private final Map<class_2338, class_2680> cachedData = new ConcurrentHashMap<class_2338, class_2680>();
    private volatile Map<class_2338, class_2680> tempRestoreMap = null;
    private static final ExecutorService EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public RandomStaffItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        if (!world.field_9236) {
            if (IS_RECORDING.get()) {
                miner.method_7353(class_2561.method_30163((String)"\u00a7c[\u58a8\u5fd2\u8033] \u6b63\u5728\u6301\u4e45\u5316\uff0c\u8bf7\u7a0d\u5019..."), true);
            } else {
                this.startParallelRecord(world, pos, miner);
            }
        }
        return false;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (user.method_5715()) {
            if (!world.field_9236) {
                this.cycleWeather(world, user);
            }
            return class_1271.method_22427((Object)stack);
        }
        if (!world.field_9236) {
            if (IS_RECORDING.get()) {
                return class_1271.method_22431((Object)stack);
            }
            if (this.cachedData.isEmpty()) {
                this.loadCacheFromFile();
            }
            if (!this.cachedData.isEmpty()) {
                this.tempRestoreMap = new ConcurrentHashMap<class_2338, class_2680>(this.cachedData);
            }
        }
        user.method_6019(hand);
        return class_1271.method_22428((Object)stack);
    }

    private void cycleWeather(class_1937 world, class_1657 player) {
        if (world instanceof class_3218) {
            String weatherName;
            class_3218 serverWorld = (class_3218)world;
            if (serverWorld.method_8546()) {
                serverWorld.method_27910(120000, 0, false, false);
                weatherName = "\u00a7e\u6674\u5929";
            } else if (serverWorld.method_8419()) {
                serverWorld.method_27910(0, 120000, true, true);
                weatherName = "\u00a78\u96f7\u96e8";
            } else {
                serverWorld.method_27910(0, 120000, true, false);
                weatherName = "\u00a7b\u96e8\u5929";
            }
            player.method_7353(class_2561.method_30163((String)("\u00a76[\u58a8\u5fd2\u8033] \u00a7f\u6c14\u5019\u5df2\u626d\u8f6c\u81f3: " + weatherName)), true);
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14709, class_3419.field_15248, 0.8f, 0.5f);
        }
    }

    private void startParallelRecord(class_1937 world, class_2338 center, class_1657 player) {
        IS_RECORDING.set(true);
        recordCenter = center;
        int radius = 70;
        int totalLayers = 141;
        AtomicInteger completedLayers = new AtomicInteger(0);
        List collectedEntries = Collections.synchronizedList(new ArrayList());
        player.method_7353(class_2561.method_30163((String)"\u00a7b[\u58a8\u5fd2\u8033] \u5f00\u59cb\u65f6\u7a7a\u8bb0\u5f55..."), false);
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSoundEvents.HIYOLI_WAND_SET, class_3419.field_15248, 10.0f, 1.0f);
        CompletableFuture.runAsync(() -> {
            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
            int yOffset = -70;
            while (yOffset <= 70) {
                int currentY = yOffset++;
                futures.add(CompletableFuture.runAsync(() -> {
                    for (int x = -70; x <= 70; ++x) {
                        for (int z = -70; z <= 70; ++z) {
                            class_2338 targetPos = center.method_10069(x, currentY, z);
                            class_2680 blockState = world.method_8320(targetPos);
                            if (blockState.method_26215()) continue;
                            class_2487 entry = new class_2487();
                            entry.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)targetPos));
                            entry.method_10566("state", (class_2520)class_2512.method_10686((class_2680)blockState));
                            collectedEntries.add(entry);
                        }
                    }
                    int finished = completedLayers.incrementAndGet();
                    player.method_7353(class_2561.method_30163((String)String.format("\u00a7e\u8fdb\u5ea6: \u00a7a%.1f%%", Float.valueOf((float)finished / 141.0f * 100.0f))), true);
                }, EXECUTOR));
            }
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenRun(() -> {
                try {
                    class_2487 root = new class_2487();
                    class_2499 nbtList = new class_2499();
                    nbtList.addAll((Collection)collectedEntries);
                    root.method_10566("Data", (class_2520)nbtList);
                    class_2507.method_30614((class_2487)root, (File)new File(DATA_FILE));
                    IS_RECORDING.set(false);
                    this.loadCacheFromFile();
                    player.method_7353(class_2561.method_30163((String)"\u00a76[\u5b8c\u6210] \u8bb0\u5f55\u5b8c\u6210"), false);
                }
                catch (IOException e) {
                    IS_RECORDING.set(false);
                }
            });
        });
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236 && IS_RECORDING.get() && recordCenter != null) {
            double cx = (double)recordCenter.method_10263() + 0.5;
            double baseY = recordCenter.method_10264();
            double cz = (double)recordCenter.method_10260() + 0.5;
            double totalHeight = 40.0;
            double halfWidth = 2.0;
            double armYCenter = 28.0;
            double armHalfHeight = 2.0;
            double armLength = 15.0;
            for (double y = 0.0; y <= totalHeight; y += 0.8) {
                this.spawnThickParticle(world, cx - halfWidth, baseY + y, cz - halfWidth);
                this.spawnThickParticle(world, cx + halfWidth, baseY + y, cz - halfWidth);
                this.spawnThickParticle(world, cx - halfWidth, baseY + y, cz + halfWidth);
                this.spawnThickParticle(world, cx + halfWidth, baseY + y, cz + halfWidth);
                if (y % 4.0 != 0.0) continue;
                this.drawRectFrame(world, cx, cz, baseY + y, halfWidth, halfWidth);
            }
            for (double xOff = -armLength; xOff <= armLength; xOff += 0.8) {
                if (!(Math.abs(xOff) > halfWidth)) continue;
                double yTop = baseY + armYCenter + armHalfHeight;
                double yBottom = baseY + armYCenter - armHalfHeight;
                this.spawnThickParticle(world, cx + xOff, yTop, cz - halfWidth);
                this.spawnThickParticle(world, cx + xOff, yTop, cz + halfWidth);
                this.spawnThickParticle(world, cx + xOff, yBottom, cz - halfWidth);
                this.spawnThickParticle(world, cx + xOff, yBottom, cz + halfWidth);
                if (!(Math.abs(xOff) >= armLength - 0.5)) continue;
                this.drawRectFrame(world, cx + xOff, cz, baseY + armYCenter, halfWidth, halfWidth);
            }
            if (world.field_9229.method_43057() > 0.6f) {
                world.method_8406((class_2394)class_2398.field_17909, cx, baseY + armYCenter, cz, 0.0, 0.0, 0.0);
            }
        }
    }

    private void drawRectFrame(class_1937 world, double cx, double cz, double y, double rx, double rz) {
        for (double i = -rx; i <= rx; i += 1.0) {
            this.spawnThickParticle(world, cx + i, y, cz - rz);
            this.spawnThickParticle(world, cx + i, y, cz + rz);
            this.spawnThickParticle(world, cx - rx, y, cz + i);
            this.spawnThickParticle(world, cx + rx, y, cz + i);
        }
    }

    private void spawnThickParticle(class_1937 world, double x, double y, double z) {
        world.method_8406((class_2394)class_2398.field_11207, x, y, z, 0.0, 0.0, 0.0);
        if (world.field_9229.method_43057() > 0.9f) {
            world.method_8406((class_2394)class_2398.field_22246, x, y, z, 0.0, 0.01, 0.0);
        }
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236 && user instanceof class_1657) {
            class_1657 player = (class_1657)user;
            Map<class_2338, class_2680> currentTempMap = this.tempRestoreMap;
            if (currentTempMap != null) {
                int usedTicks = this.method_7881(stack) - remainingUseTicks;
                int batchSize = 10 + usedTicks / 20 * 400;
                this.performDynamicRandomRestore(world, player, stack, batchSize, currentTempMap);
            }
        }
    }

    private void performDynamicRandomRestore(class_1937 world, class_1657 player, class_1799 stack, int amount, Map<class_2338, class_2680> currentMap) {
        if (currentMap.isEmpty()) {
            player.method_7353(class_2561.method_30163((String)"\u00a7a[\u5b8c\u6210] \u65f6\u7a7a\u56de\u6eaf\u5b8c\u6210\uff01"), true);
            this.tempRestoreMap = null;
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            stack.method_7956(100, (class_1309)player, p -> p.method_20236(player.method_6058()));
        }
        class_5819 random = world.method_8409();
        ArrayList<class_2338> keys = new ArrayList<class_2338>(currentMap.keySet());
        int actualToRestore = Math.min(amount, keys.size());
        for (int i = 0; i < actualToRestore && !keys.isEmpty(); ++i) {
            int index = random.method_43048(keys.size());
            class_2338 targetPos = (class_2338)keys.remove(index);
            class_2680 savedState = currentMap.remove(targetPos);
            if (savedState == null || !world.method_24794(targetPos) || world.method_8320(targetPos) == savedState) continue;
            world.method_8501(targetPos, savedState);
        }
        int total = this.cachedData.size();
        if (total > 0) {
            double progress = (double)(total - currentMap.size()) / (double)total * 100.0;
            player.method_7353(class_2561.method_30163((String)String.format("\u00a7d\u65f6\u7a7a\u56de\u6eaf\u4e2d: \u00a7f%.2f%% \u00a78(\u901f\u5ea6: %d/t)", progress, actualToRestore)), true);
        }
        if (world.method_8510() % 4L == 0L) {
            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), ModSoundEvents.HIYOLI_WAND_USE, class_3419.field_15248, 0.5f, 1.2f);
        }
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        this.tempRestoreMap = null;
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    public int method_7881(class_1799 stack) {
        return 72000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCacheFromFile() {
        File file = new File(DATA_FILE);
        if (!file.exists()) {
            return;
        }
        try {
            class_2487 root = class_2507.method_30613((File)file);
            class_2499 list = root.method_10554("Data", 10);
            Map<class_2338, class_2680> map = this.cachedData;
            synchronized (map) {
                this.cachedData.clear();
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 entry = list.method_10602(i);
                    this.cachedData.put(class_2512.method_10691((class_2487)entry.method_10562("pos")), class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)entry.method_10562("state")));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

