/*
 * Decompiled with CFR 0.152.
 */
package love.ikaros.minecraft.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1900;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4770;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ModExplosion
extends class_1927 {
    private static final class_5362 DEFAULT_BEHAVIOR = new class_5362();
    private static final int field_30960 = 16;
    private final boolean createFire;
    private final class_1927.class_4179 destructionType;
    private final class_5819 random = class_5819.method_43047();
    private final class_1937 world;
    private final double x;
    private final double y;
    private final double z;
    @Nullable
    private final class_1297 entity;
    private final float power;
    private final class_1282 damageSource;
    private final class_5362 behavior;
    private final ObjectArrayList<class_2338> affectedBlocks = new ObjectArrayList();
    private final Map<class_1657, class_243> affectedPlayers = Maps.newHashMap();

    public ModExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, List<class_2338> affectedBlocks) {
        this(world, entity, x, y, z, power, false, class_1927.class_4179.field_40879, affectedBlocks);
    }

    public ModExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType, List<class_2338> affectedBlocks) {
        this(world, entity, x, y, z, power, createFire, destructionType);
        this.affectedBlocks.addAll(affectedBlocks);
    }

    public ModExplosion(class_1937 world, @Nullable class_1297 entity, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType) {
        this(world, entity, null, null, x, y, z, power, createFire, destructionType);
    }

    public ModExplosion(class_1937 world, @Nullable class_1297 entity, @Nullable class_1282 damageSource, @Nullable class_5362 behavior, double x, double y, double z, float power, boolean createFire, class_1927.class_4179 destructionType) {
        super(world, entity, damageSource, behavior, x, y, z, power, createFire, destructionType);
        this.world = world;
        this.entity = entity;
        this.power = power;
        this.x = x;
        this.y = y;
        this.z = z;
        this.createFire = createFire;
        this.destructionType = destructionType;
        this.damageSource = damageSource == null ? world.method_48963().method_48807((class_1927)this) : damageSource;
        this.behavior = behavior == null ? this.chooseBehavior(entity) : behavior;
    }

    private class_5362 chooseBehavior(@Nullable class_1297 entity) {
        return entity == null ? DEFAULT_BEHAVIOR : new class_5361(entity);
    }

    public static float getExposure(class_243 source, class_1297 entity) {
        class_238 box = entity.method_5829();
        double d = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
        double e = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
        double f = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
        double g = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
        double h = (1.0 - Math.floor(1.0 / f) * f) / 2.0;
        if (!(d < 0.0 || e < 0.0 || f < 0.0)) {
            int i = 0;
            int j = 0;
            for (double k = 0.0; k <= 1.0; k += d) {
                for (double l = 0.0; l <= 1.0; l += e) {
                    for (double m = 0.0; m <= 1.0; m += f) {
                        double n = class_3532.method_16436((double)k, (double)box.field_1323, (double)box.field_1320);
                        double o = class_3532.method_16436((double)l, (double)box.field_1322, (double)box.field_1325);
                        double p = class_3532.method_16436((double)m, (double)box.field_1321, (double)box.field_1324);
                        class_243 vec3d = new class_243(n + g, o, p + h);
                        if (entity.method_37908().method_17742(new class_3959(vec3d, source, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }

    public void method_8348() {
        this.world.method_43275(this.entity, class_5712.field_28178, new class_243(this.x, this.y, this.z));
        HashSet set = Sets.newHashSet();
        int i = 16;
        float radius = this.power;
        int radiusCeil = (int)Math.ceil(radius);
        for (int x = -radiusCeil; x <= radiusCeil; ++x) {
            for (int y = -radiusCeil; y <= radiusCeil; ++y) {
                for (int z = -radiusCeil; z <= radiusCeil; ++z) {
                    class_2680 state;
                    float resistance;
                    float strength;
                    class_2338 pos = new class_2338((int)this.x + x, (int)this.y + y, (int)this.z + z);
                    double distance = Math.sqrt(x * x + y * y + z * z);
                    if (distance > (double)radius || !((strength = this.power * (1.0f - (float)(distance / (double)radius))) > (resistance = (state = this.world.method_8320(pos)).method_26204().method_9520()))) continue;
                    this.affectedBlocks.add((Object)pos);
                }
            }
        }
        float q = this.power;
        int k = class_3532.method_15357((double)(this.x - (double)q - 1.0));
        int lx = class_3532.method_15357((double)(this.x + (double)q + 1.0));
        int r = class_3532.method_15357((double)(this.y - (double)q - 1.0));
        int s = class_3532.method_15357((double)(this.y + (double)q + 1.0));
        int t = class_3532.method_15357((double)(this.z - (double)q - 1.0));
        int u = class_3532.method_15357((double)(this.z + (double)q + 1.0));
        List list = this.world.method_8335(this.entity, new class_238((double)k, (double)r, (double)t, (double)lx, (double)s, (double)u));
        class_243 vec3d = new class_243(this.x, this.y, this.z);
        for (int v = 0; v < list.size(); ++v) {
            class_1657 playerEntity;
            double ad;
            double z;
            double y;
            double x;
            double aa;
            double w;
            class_1297 entity = (class_1297)list.get(v);
            if (entity.method_5659() || !((w = Math.sqrt(entity.method_5707(vec3d)) / (double)q) <= 1.0) || (aa = Math.sqrt((x = entity.method_23317() - this.x) * x + (y = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.y) * y + (z = entity.method_23321() - this.z) * z)) == 0.0) continue;
            x /= aa;
            y /= aa;
            z /= aa;
            double ac = 1.0 - w;
            float damage = (float)(ac * 7.0 * (double)q + 1.0);
            entity.method_5643(this.method_8349(), damage);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                ad = class_1900.method_8237((class_1309)livingEntity, (double)ac);
            } else {
                ad = ac;
            }
            class_243 vec3d2 = new class_243(x *= ad, y *= ad, z *= ad);
            entity.method_18799(entity.method_18798().method_1019(vec3d2));
            if (!(entity instanceof class_1657) || (playerEntity = (class_1657)entity).method_7325() || playerEntity.method_7337() && playerEntity.method_31549().field_7479) continue;
            this.affectedPlayers.put(playerEntity, vec3d2);
        }
    }

    public void method_8350(boolean particles) {
        boolean bl = this.method_46667();
        if (particles) {
            if (!(this.power < 2.0f) && bl) {
                this.world.method_8406((class_2394)class_2398.field_11221, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.method_8406((class_2394)class_2398.field_11236, this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
        if (bl) {
            ObjectArrayList objectArrayList = new ObjectArrayList();
            boolean bl2 = this.method_8347() instanceof class_1657;
            class_156.method_43028(this.affectedBlocks, (class_5819)this.world.field_9229);
            for (class_2338 blockPos : this.affectedBlocks) {
                class_2680 blockState = this.world.method_8320(blockPos);
                class_2248 block = blockState.method_26204();
                if (blockState.method_26215()) continue;
                class_2338 blockPos2 = blockPos.method_10062();
                this.world.method_16107().method_15396("explosion_blocks");
                this.world.method_8652(blockPos, class_2246.field_10124.method_9564(), 3);
                block.method_9586(this.world, blockPos, (class_1927)this);
                this.world.method_16107().method_15407();
            }
            for (Pair pair : objectArrayList) {
                class_2248.method_9577((class_1937)this.world, (class_2338)((class_2338)pair.getSecond()), (class_1799)((class_1799)pair.getFirst()));
            }
        }
        if (this.createFire) {
            for (class_2338 blockPos3 : this.affectedBlocks) {
                if (this.random.method_43048(3) != 0 || !this.world.method_8320(blockPos3).method_26215() || !this.world.method_8320(blockPos3.method_10074()).method_26216((class_1922)this.world, blockPos3.method_10074())) continue;
                this.world.method_8501(blockPos3, class_4770.method_24416((class_1922)this.world, (class_2338)blockPos3));
            }
        }
    }

    public boolean method_46667() {
        return this.destructionType != class_1927.class_4179.field_40878;
    }

    private static void tryMergeStack(ObjectArrayList<Pair<class_1799, class_2338>> stacks, class_1799 stack, class_2338 pos) {
        int i = stacks.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)stacks.get(j);
            class_1799 itemStack = (class_1799)pair.getFirst();
            if (!class_1542.method_24017((class_1799)itemStack, (class_1799)stack)) continue;
            class_1799 itemStack2 = class_1542.method_24018((class_1799)itemStack, (class_1799)stack, (int)16);
            stacks.set(j, (Object)Pair.of((Object)itemStack2, (Object)((class_2338)pair.getSecond())));
            if (!stack.method_7960()) continue;
            return;
        }
        stacks.add((Object)Pair.of((Object)stack, (Object)pos));
    }

    public class_1282 method_8349() {
        return this.damageSource;
    }

    public Map<class_1657, class_243> method_8351() {
        return this.affectedPlayers;
    }

    @Nullable
    public class_1309 method_8347() {
        class_1309 livingEntity2;
        class_1676 projectileEntity;
        if (this.entity == null) {
            return null;
        }
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1541) {
            class_1541 tntEntity = (class_1541)class_12972;
            return tntEntity.method_6970();
        }
        class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 livingEntity = (class_1309)class_12972;
            return livingEntity;
        }
        class_1297 class_12973 = this.entity;
        return class_12973 instanceof class_1676 && (class_12973 = (projectileEntity = (class_1676)class_12973).method_24921()) instanceof class_1309 ? (livingEntity2 = (class_1309)class_12973) : null;
    }

    @Nullable
    public class_1297 method_46406() {
        return this.entity;
    }

    public void method_8352() {
        this.affectedBlocks.clear();
    }

    public List<class_2338> method_8346() {
        return this.affectedBlocks;
    }

    public static enum DestructionType {
        KEEP,
        DESTROY,
        DESTROY_WITH_DECAY;

    }
}

